<?php
/**
 * Plugin Name: Elementor WHMCS Elements Pro
 * Description: Adds Various Pro Widgets : Live Domain Searcher, 5+ Style Pricing Table, KB, Domain TLD Pricing from WHMCS in Elementor for being used with your WHMCS or WHMCS Bridge Plugin for Hosting Website.
 * Version:     4.0
 * Author:      voidCoders
 * Author URI:  http://voidcoders.com
 * Plugin URI:  https://voidcoders.com/product/elementor-whmcs-elements-pro/
 * Elementor tested up to: 3.12
 * Elementor Pro tested up to: 3.12
 * Text Domain: void_ewhmcsep
 */
/* This loads the plugin.php file which is the main one */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

define( 'VOID_EWHMCSEP_ELEMENTS_FILE_', __FILE__ );

define( 'VOID_EWHMCSEP_PLUGIN_NAME', 'Elementor WHMCS Elements Pro' );

/**
 *
 * Load the plugin after Elementor (and other plugins) are loaded.
 *
 * @since 1.0.0
 */


function void_ewhmcsep_load_elements() {
	// Load localization file
	load_plugin_textdomain( 'void_ewhmcsep' );
// Include file if function does not exist
  if (!function_exists('is_plugin_active')) {
      include_once(ABSPATH . 'wp-admin/includes/plugin.php');
  }

	// Notice if the Elementor is not active
	if ( ! did_action( 'elementor/loaded' ) ) {
    add_action( 'admin_notices', 'void_ewhmcsep_fail_load' );
		return;
	}

	// Check version required
  $elementor_version_required = '3.0';
  if ( ! version_compare( ELEMENTOR_VERSION, $elementor_version_required, '>=' ) ) {
    add_action( 'admin_notices', 'void_ewhmcsep_fail_load_out_of_date' );
    return;
  }

  if ( is_plugin_active( 'void-elementor-whmcs-elements/void-elementor-whmcs-elements.php' ) ) {
      add_action( 'admin_notices', 'void_ewhmcsep_delete_free_plugin' );
      return;
  }

	// Require the main plugin file
	require( __DIR__ . '/plugin.php' );   //loading the main plugin
  require( __DIR__ . '/helper/helper.php' ); // load helper functions
  require( __DIR__ . '/helper/epro-pricing-table.php' ); // load helper functions

}
add_action( 'plugins_loaded', 'void_ewhmcsep_load_elements' );   //notiung but checking and notice

function void_ewhmcsep_fail_load_out_of_date() {  // if plungin is outdated
  if ( ! current_user_can( 'update_plugins' ) ) {
    return;
  }
  $message = '<p>' . sprintf(__('<strong>%s</strong> Needs <a href="%s">Elementor</a> version higher than the one you have! Please update your <strong>Elementor</strong> plugin.','void_ewhmcsep'), 'https://wordpress.org/plugins/elementor/',VOID_EWHMCSEP_PLUGIN_NAME ) . '</p>';

  echo '<div class="error">' . $message . '</div>';
}

function void_ewhmcsep_fail_load() {  // if plungin is not isntalled
  if ( ! current_user_can( 'update_plugins' ) ) {
    return;
  }
  $message = '<p>' . sprintf(__('<a href="%s">Elementor</a> must be installed and activated for <strong>%s</strong> plugin to work! Please Install it first','void_ewhmcsep'), 'https://wordpress.org/plugins/elementor/',VOID_EWHMCSEP_PLUGIN_NAME ) . '</p>';
 
  echo '<div class="error">' . $message . '</div>';
}

// remove the free plugin
function void_ewhmcsep_delete_free_plugin() {
   ?>
   <div class="notice notice-error">
      <p><?php echo sprintf( __( 'You need to deactivate the free Elementor WHMCS Elements plugin. Do not worry all your data will be still there. %sClick here to Deactivate Free Version%s', 'void_ewhmcsep' ), '<a href="' . wp_nonce_url( 'plugins.php?action=deactivate&amp;plugin=void-elementor-whmcs-elements%2Fvoid-elementor-whmcs-elements.php&amp;plugin_status=all&amp;paged=1&amp;s=', 'deactivate-plugin_void-elementor-whmcs-elements/void-elementor-whmcs-elements.php' ) . '">', '</a>' ); ?></p>
   </div>
   <?php
}


function void_ewhmcsep_register_settings() {
   add_option( 'void_whmcse_identifier_key', '*******');
   add_option( 'void_whmcse_secret_key', '********');
   add_option( 'void_whmcse_url', 'http://mywhmcsurl.com');
   register_setting( 'void_ewhmcse_options_group', 'void_whmcse_identifier_key' );
   register_setting( 'void_ewhmcse_options_group', 'void_whmcse_secret_key' );
   register_setting( 'void_ewhmcse_options_group', 'void_whmcse_url' );
}
add_action( 'admin_init', 'void_ewhmcsep_register_settings' );


function void_ewhmcsep_register_options_page() {
  add_menu_page('Elementor WHMCS Elements Settings', 'Elementor WHMCS Elements', 'manage_options', 'void_ewhmcsep', 'void_ewhmcsep_options_page','dashicons-welcome-widgets-menus', 25);
}
add_action('admin_menu', 'void_ewhmcsep_register_options_page');

function void_ewhmcsep_options_page()
{
?>
  <div>
  <h2>Elementor WHMCS Elements Pro Settings</h2><hr>

  <form method="post" action="options.php">
    <?php settings_fields( 'void_ewhmcse_options_group' ); ?>
    <h3>WHMCS API Authentication</h3>

    <p>If you have your own whmcs portal and have access to settings/api, You can put your WHMCS API details here to be inegrated with Elementor whmcs elements domain ajax search. This would produce more accurate resutls for your domain search which would be better for a domain selling business.</p> 
    <a href="https://developers.whmcs.com/api/authentication/" target="_blank">Setup API access in WHMCS portal</a> <br>
    <small> 1.<b> Needed Allowed API Actions:</b> DomainWhois <br>2. You must allow your server IP in WHMCS ( Setting Icon > System Settings > General Settings > Security > API IP Access Restrictionto use the API)</small>

    <br><br>
    <table>

      <tr valign="middle">
        <th scope="row"><label for="void_whmcse_url">WHMCS URL</label></th>
        <td><input type="url" id="void_whmcse_url" name="void_whmcse_url" value="<?php echo get_option('void_whmcse_url'); ?>" />
        </td>
      </tr>

      <tr valign="middle">
        <th scope="row"><label for="void_whmcse_identifier_key">Identifier</label></th>
        <td><input type="password" id="void_whmcse_identifier_key" name="void_whmcse_identifier_key" value="<?php echo get_option('void_whmcse_identifier_key'); ?>" />
        </td>
      </tr> 

      <tr valign="middel">
        <th scope="row"><label for="void_whmcse_secret_key">Secret</label></th>
        <td><input type="password" id="void_whmcse_secret_key" name="void_whmcse_secret_key" value="<?php echo get_option('void_whmcse_secret_key'); ?>" />
        </td>
      </tr>
     
    </table>
    <?php  submit_button(); ?>
  </form>
  </div>
<?php
}


